//=============================================================================
// Dragon.
//=============================================================================
class Dragon_Bot extends Animal_Bot;

var     name         WaitAnim;
var(AI) float        LikesFlying;
var     float        lastCheck;
var     float        stuck;
var     float        hitTimer;
var     float        fright;
var     float        initialRate;

function PlayFlying()
{
	LoopAnim('Tread', 1.0, 0.1);
	initialRate = AnimRate;
}

function BeginPlay()
{
	Super.BeginPlay();
	AIClearEventCallback('WeaponFire');
}

state Flying
{
	simulated function HitWall(vector HitNormal, actor Wall)
	{
		local Vector  newVector;
		local Rotator newRotator;

		if (hitTimer > 0)
			return;

		hitTimer = 0.5;
		Disable('HitWall');

		newVector    = (Velocity dot HitNormal) * HitNormal * (-2.0) + Velocity;
		newRotator   = Rotator(newVector);

		SetRotation(newRotator);
		DesiredRotation = newRotator;

		Acceleration = vect(0, 0, 0);
		Velocity     = newVector;
		if (VSize(Velocity) < 0.01)
			Velocity = Vector(Rotation);

		destLoc = Location + 80*Velocity/VSize(Velocity);
		GotoState('Flying', 'KeepGoing');
	}

	function Tick(float deltaSeconds)
	{
		local float rate;

		Global.Tick(deltaSeconds);

		if (hitTimer > 0)
		{
			hitTimer -= deltaSeconds;
			if (hitTimer < 0)
			{
				hitTimer = 0;
				Enable('HitWall');
			}
		}
		stuck += deltaSeconds;

		if (Physics == PHYS_Flying)
		{
			rate = FClamp(Acceleration.Z+250, 0, 500)/500 + 0.5;
			AnimRate = initialRate*rate;
		}
		else if (Physics == PHYS_Falling)
			AnimRate = initialRate*0.1;
	}
	function bool ReadyToLand()
	{
		local Pawn fearPawn;

		fearPawn = FrightenedByPawn();
		if (fearPawn != None)
		{
			return false;
		}
		else if (fright > 0)
			return false;
		else if (FRand() <= LikesFlying)
			return false;
		else
			return true;
	}

	function CheckStuck()
	{
		if (stuck > 10.0)
			GotoState('Flying', 'Drop');
	}

	function bool CheckDestination(vector dest, out float magnitude, float minDist)
	{
		local bool retval;
		local float dist;

		retval = False;
		dist = magnitude;
		while (dist > minDist)
		{
			if (PointReachable(Location+(dest*dist)))
				break;
			dist *= 0.5;
		}
		if (dist > minDist)
		{
			magnitude = dist;
			retval    = True;
		}

		return (retval);
	}

	function PickDestination()
	{
		local vector dest;
		local float  magnitude;
		local int    iterations;
		local bool   bValid;

		iterations = 4;
		while (iterations > 0)
		{
			//magnitude = 800+(FRand()*100-50);
			magnitude = 1200+(FRand()*200-100);
			dest = VRand();
			bValid = CheckDestination(dest, magnitude, 100);
			if (!bValid && (dest.Z != 0))
			{
				dest.Z = -dest.Z;
				bValid = CheckDestination(dest, magnitude, 100);
			}
			if (bValid)
				break;

			iterations--;
		}
		if (iterations > 0)
		{
			destLoc = Location + (dest*magnitude);
			stuck = 0;
		}
		else
		{
			if (VSize(Velocity) > 0.001)
				destLoc = 40*Velocity/VSize(Velocity);
			else
				destLoc = Velocity;
			if (stuck > 5.0)
				destLoc += VRand()*((stuck-5.0)*3.0);
			destLoc += Location;
		}
	}

	function PickInitialDestination()
	{
		local vector  dest;
		local rotator rot;
		local float   magnitude;

		//magnitude = 200 + (FRand()*50-25);
		magnitude = 300 + (FRand()*100-50);
		rot.yaw = Rotation.yaw;
		//rot.pitch = 8192+(Rand(6000)-3000);
		rot.pitch = 10000+(Rand(6000)-3000);
		rot.roll = 0;
		dest = Vector(rot);
		if (CheckDestination(dest, magnitude, 20))
			destLoc = Location + (dest*magnitude);
		else
			destLoc = Location + vect(0, 0, 100);
	}

	function bool PickFinalDestination()
	{
		local vector dest;
		local Actor  landActor;
		local vector hitLoc;
		local vector hitNorm;
		local vector endPoint;
		local vector startPoint;
		local int    iterations;
		local bool   retval;

		retval = False;

		iterations = 3;
		while (iterations > 0)
		{
			startPoint = VRand()*100 + Location;
			startPoint.Z = Location.Z;
			endPoint = startPoint;
			endPoint.Z -= 1000;
			foreach TraceActors(Class'Actor', landActor, hitLoc, hitNorm, endPoint, startPoint)
			{
				if (landActor == Level)
				{
					hitLoc.Z += CollisionHeight+5;
					if (PointReachable(hitLoc))
						break;
				}
				else
				{
					landActor = None;
					break;
				}
			}
			if (landActor != None)
			{
				break;
			}
			iterations--;
		}

		if (iterations > 0)
		{
			destLoc = hitLoc;
			retval  = True;
		}

		return (retval);
	}

	function BeginState()
	{
		SetPhysics(PHYS_Flying);
		Enable('HitWall');
		stuck       = 0;
		hitTimer    = 0;
		AISetEventCallback('LoudNoise', 'HeardNoise');
		SetCollision(true, false, false);
	}

	function EndState()
	{
		SetCollision(true, true, true);
		SetPhysics(PHYS_Falling);
		Enable('HitWall');
		AIClearEventCallback('LoudNoise');
	}

Begin:
	PlayFlying();

StartFlying:
	PickInitialDestination();
	MoveTo(destLoc);

Fly:
	if (ReadyToLand())
		Goto('Land');
	PickDestination();

KeepGoing:
	CheckStuck();
	MoveTo(destLoc);
	Goto('Fly');

Land:
	if (!PickFinalDestination())
	{
		PickDestination();
		Goto('KeepGoing');
	}
	MoveTo(destLoc);
	SetPhysics(PHYS_Falling);
	WaitForLanding();
	Acceleration = vect(0, 0, 0);
	GotoState('Wandering');

Drop:
	DesiredRotation.pitch = -16384;
	SetPhysics(PHYS_Falling);
	Sleep(0.5);
	SetPhysics(PHYS_Flying);
	Goto('Fly');
}

function bool FilterDamageType(Pawn instigatedBy, Vector hitLocation,
                               Vector offset, Name damageType)
{
	if ((damageType == 'TearGas') || (damageType == 'HalonGas') || (damageType == 'PoisonGas'))
		return false;
	else
		return Super.FilterDamageType(instigatedBy, hitLocation, offset, damageType);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	else if ((damageType == 'TearGas') || (damageType == 'HalonGas'))
		GotoNextState();
	else if (damageType == 'Stunned')
		GotoNextState();
	else if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

function vector GetSwimPivot()
{
	// THIS IS A HIDEOUS, UGLY, MASSIVELY EVIL HACK!!!!
	return (vect(0,0,1)*CollisionHeight);
}

function TweenToAttack(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Tread', tweentime, GetSwimPivot());
	else
		TweenAnimPivot('Attack', tweentime);
}

function PlayAttack()
{
	PlayAnimPivot('Attack');
}

function PlayPanicRunning()
{
	PlayRunning();
}

function PlayTurning()
{
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',,,, GetSwimPivot());
	else if (Physics == PHYS_Flying)
		LoopAnimPivot('Tread',1.5,,, GetSwimPivot());
	else
		LoopAnimPivot('Walk', 0.1);
}

function TweenToWalking(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Tread', tweentime, GetSwimPivot());
	else if (Physics == PHYS_Flying)
		LoopAnimPivot('Tread',1.5,,, GetSwimPivot());
	else
		TweenAnimPivot('Walk', tweentime);
}

function PlayWalking()
{
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',,,, GetSwimPivot());
	else if (Physics == PHYS_Flying)
		LoopAnimPivot('Tread',1.5,,, GetSwimPivot());
	else
		LoopAnimPivot('Walk', , 0.15);
}

function TweenToRunning(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Tread', tweentime, GetSwimPivot());
	else if (Physics == PHYS_Flying)
		LoopAnimPivot('Tread',1.5,,, GetSwimPivot());
	else
		LoopAnimPivot('Run',, tweentime);
}

function PlayRunning()
{
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',1.5,,, GetSwimPivot());
	else if (Physics == PHYS_Flying)
		LoopAnimPivot('Tread',1.5,,, GetSwimPivot());
	else
		LoopAnimPivot('Run', 1.5);
}
function TweenToWaiting(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Tread', tweentime, GetSwimPivot());
	else if (Physics == PHYS_Flying)
		LoopAnimPivot('Tread',1.5,,, GetSwimPivot());
	else
		TweenAnimPivot('BreatheLight', tweentime);
}
function PlayWaiting()
{
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',1.5,,, GetSwimPivot());
	else if (Physics == PHYS_Flying)
		LoopAnimPivot('Tread',1.5,,, GetSwimPivot());
	else
		LoopAnimPivot('BreatheLight', , 0.3);
}

function PlayTakingHit(EHitLocation hitPos)
{
	local vector pivot;
	local name   animName;

	animName = '';
	if (!Region.Zone.bWaterZone)
	{
		switch (hitPos)
		{
			case HITLOC_HeadFront:
			case HITLOC_TorsoFront:
			case HITLOC_LeftArmFront:
			case HITLOC_RightArmFront:
			case HITLOC_LeftLegFront:
			case HITLOC_RightLegFront:
				animName = 'HitFront';
				break;

			case HITLOC_HeadBack:
			case HITLOC_TorsoBack:
			case HITLOC_LeftArmBack:
			case HITLOC_RightArmBack:
			case HITLOC_LeftLegBack:
			case HITLOC_RightLegBack:
				animName = 'HitBack';
				break;
		}
		pivot = vect(0,0,0);
	}

	if (animName != '')
		PlayAnimPivot(animName, , 0.1, pivot);

}

function vector GetChompPosition()
{
	return (Location+Vector(Rotation)*(CollisionRadius+10)+vect(0,0,-10));
}

function PlayEating()
{
	PlayAnimPivot('Eat', 2.0, 0.2);
}

function SpewBlood(vector Position)
{
	local float         size;
	local FleshFragment chunk;

	size = (CollisionRadius + CollisionHeight) / 2;  // yes, we *are* using the Greasel's size...  :)
	if ((FRand() < 0.5) && (size > 10.0))
	{
		chunk = spawn(class'FleshFragment', None,, Position);
		if (chunk != None)
		{
			chunk.DrawScale = size / 25;
			chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
			chunk.bFixedRotationDir = True;
			chunk.RotationRate = RotRand(False);
			chunk.Velocity = VRand()*100;
			chunk.Velocity.Z = chunk.Velocity.Z + 250;
		}
	}
	else
		Super.SpewBlood(Position);
}

// sound functions
function PlayEatingSound()
{
	PlaySound(sound'GreaselEat', SLOT_None,,, 384);
}

function PlayIdleSound()
{
	if (FRand() < 0.5)
		PlaySound(sound'GreaselIdle', SLOT_None);
	else
		PlaySound(sound'Fart', SLOT_None);
}

function PlayScanningSound()
{
	if (FRand() < 0.3)
	{
		if (FRand() < 0.5)
			PlaySound(sound'GreaselIdle', SLOT_None);
		else
			PlaySound(sound'Fart', SLOT_None);
	}
}

function PlayTargetAcquiredSound()
{
	PlaySound(sound'GreaselAlert', SLOT_None);
}

function PlayCriticalDamageSound()
{
	PlaySound(sound'GreaselFlee', SLOT_None);
}

defaultproperties
{
     bPlayDying=True
     FoodClass=Class'DeusEx.DeusExCarcass'
     FoodHealth=10
     bMessyEater=True
     MinHealth=20.000000
     CarcassType=Class'Markistan.DragonCarcass'
     WalkingSpeed=0.080000
     bCanBleed=True
     ShadowScale=1.500000
     InitialAlliances(0)=(AllianceName=Player,AllianceLevel=-1.000000,bPermanent=True)
     InitialAlliances(1)=(AllianceName=Commi,AllianceLevel=-1.000000,bPermanent=True)
     InitialAlliances(2)=(AllianceName=Markistan,AllianceLevel=-1.000000,bPermanent=True)
     InitialInventory(0)=(Inventory=Class'Markistan.WeaponDragonFire')
     InitialInventory(1)=(Inventory=Class'Markistan.AmmoDragonFire',Count=9999)
     InitialInventory(2)=(Inventory=Class'Markistan.WeaponDragonBite')
     WalkSound=Sound'DeusExSounds.Animal.GreaselFootstep'
     bSpawnBubbles=False
     bCanSwim=True
     bCanGlide=False
     GroundSpeed=350.000000
     WaterSpeed=50.000000
     AirSpeed=475.000000
     AccelRate=500.000000
     BaseEyeHeight=12.500000
     Health=100
     UnderWaterTime=99999.000000
     AttitudeToPlayer=ATTITUDE_Ignore
     HitSound1=Sound'DeusExSounds.Animal.GreaselPainSmall'
     HitSound2=Sound'DeusExSounds.Animal.GreaselPainLarge'
     Die=Sound'DeusExSounds.Animal.GreaselDeath'
     Alliance=Dragon
     DrawType=DT_Mesh
     Skin=Texture'Markistan.Skins.DragonTex1'
     Mesh=LodMesh'DeusExCharacters.Greasel'
     DrawScale=1.500000
     CollisionHeight=24.879999
     Mass=40.000000
     Buoyancy=40.000000
     BindName="Dragon"
     FamiliarName="Dragon"
     UnfamiliarName="Dragon"
     bCanFly=True
     PawnsName="Adult Dragon"
     PawnsArticle="an"
}
